%------------------------------------------------------------------------------
% File     : LCL614^1 : TPTP v7.4.0. Released v3.6.0.
% Domain   : Logical Calculi
% Problem  : Regularity is a derived rule in K
% Version  : [Ben08] axioms.
% English  :

% Refs     : [Fit07] Fitting (2007), Modal Proof Theory
%          : [Ben08] Benzmueller (2008), Email to G. Sutcliffe
% Source   : [Ben08]
% Names    : Fitting-HB-5 [Ben08]

% Status   : Theorem
% Rating   : 0.00 v7.1.0, 0.12 v7.0.0, 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v5.3.0, 0.40 v5.2.0, 0.20 v4.1.0, 0.00 v4.0.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :   36 (   0 unit;  20 type;  15 defn)
%            Number of atoms       :   89 (  15 equality;  46 variable)
%            Maximal formula depth :   10 (   5 average)
%            Number of connectives :   46 (   3   ~;   1   |;   2   &;  38   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   83 (  83   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   25 (  20   :;   0   =)
%            Number of variables   :   39 (   2 sgn;   7   !;   4   ?;  28   ^)
%                                         (  39   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include simple maths definitions and axioms
include('Axioms/LCL008^0.ax').
%------------------------------------------------------------------------------
%----Conjecture
thf(regularity,conjecture,(
    ! [R: $i > $i > $o,X: $i > $o,Y: $i > $o] :
      ( ( mvalid @ ( mimpl @ X @ Y ) )
     => ( mvalid @ ( mimpl @ ( mbox @ R @ X ) @ ( mbox @ R @ X ) ) ) ) )).

%------------------------------------------------------------------------------
